---
name: "cursor-usage-analytics"
description: |
  Track and analyze Cursor usage metrics. Triggers on "cursor analytics",
  "cursor usage", "cursor metrics", "cursor reporting", "cursor dashboard". Use when working with cursor usage analytics functionality. Trigger with phrases like "cursor usage analytics", "cursor analytics", "cursor".
allowed-tools: "Read, Write, Edit, Bash(cmd:*)"
version: 1.0.0
license: MIT
author: "Jeremy Longshore <jeremy@intentsolutions.io>"
---

# Cursor Usage Analytics

## Overview

This skill helps you track and analyze Cursor usage metrics. It covers available analytics for Business/Enterprise plans, dashboard views, custom reports, API access, and strategies for optimizing team productivity based on usage data.

## Prerequisites

- Cursor Business or Enterprise subscription
- Admin access to organization dashboard
- Understanding of key metrics
- Access to team for feedback

## Instructions

1. Access Admin Dashboard > Analytics
2. Review key metrics (users, completions, costs)
3. Identify trends and anomalies
4. Create custom reports for stakeholders
5. Set up scheduled report delivery
6. Plan actions based on insights

## Output

- Usage metrics and trends
- Team productivity insights
- Cost analysis and optimization
- Custom reports for stakeholders
- Data-driven improvement plans

## Error Handling

See `{baseDir}/references/errors.md` for comprehensive error handling.

## Examples

See `{baseDir}/references/examples.md` for detailed examples.

## Resources

- [Cursor Analytics Dashboard](https://cursor.com/dashboard)
- [Usage Metrics Guide](https://cursor.com/docs/analytics)
- [ROI Calculation Tips](https://cursor.com/blog/roi)
