# End-to-End Test Framework Plugin

Browser-based E2E test automation with Playwright, Cypress, and Selenium support for complete user workflow testing.

## Features

- **Multi-framework support** - Playwright, Cypress, Selenium
- **User workflow testing** - Complete journey testing
- **Page Object Model** - Maintainable test structure
- **Cross-browser testing** - Chrome, Firefox, Safari, Edge
- **Mobile emulation** - Responsive testing
- **Visual testing** - Screenshot comparison
- **Network interception** - Mock APIs and responses

## Installation

```bash
/plugin install e2e-test-framework@claude-code-plugins-plus
```

## Usage

```bash
/generate-e2e          # Generate E2E tests
/e2e                   # Shortcut
```

## Example

Generate E2E tests for user registration and login flow:

```
Create E2E tests for the user registration and login workflow
```

## Requirements

- Claude Code CLI
- Node.js
- Playwright / Cypress / Selenium WebDriver

## License

MIT
