---
name: css-utility-generator
description: >
  Generate utility CSS classes for spacing, colors, typography, and layout
shortcut: cug
category: frontend
difficulty: beginner
estimated_time: 2-5 minutes
---
# CSS Utility Generator

Generates utility CSS classes similar to Tailwind CSS for common styling needs, creating a custom utility-first CSS framework.

## What This Command Does

**Utility Class Generation:**
-  Spacing utilities (margin, padding)
-  Color utilities (background, text, border)
-  Typography utilities (font size, weight, line height)
-  Layout utilities (flexbox, grid, display)
-  Responsive breakpoints
-  Custom design tokens

**Output:** Complete utility CSS file with organized sections

**Time:** 2-5 minutes

---

## Usage

```bash
# Generate full utility class system
/css-utility-generator

# Shortcut
/cug

# Generate specific categories
/cug --categories spacing,colors,typography

# Custom design tokens
/cug --config design-tokens.json

# With custom breakpoints
/cug --breakpoints mobile:640px,tablet:768px,desktop:1024px
```

---

## Example Output

**Input:**
```
/cug --categories spacing,colors,flex
```

**Generated utilities.css:**

```css
/* ==========================================================================
   Utility CSS Classes
   Generated by CSS Utility Generator
   ========================================================================== */

/* Spacing Utilities
   ========================================================================== */

/* Margin */
.m-0 { margin: 0; }
.m-1 { margin: 0.25rem; }   /* 4px */
.m-2 { margin: 0.5rem; }    /* 8px */
.m-3 { margin: 0.75rem; }   /* 12px */
.m-4 { margin: 1rem; }      /* 16px */
.m-5 { margin: 1.25rem; }   /* 20px */
.m-6 { margin: 1.5rem; }    /* 24px */
.m-8 { margin: 2rem; }      /* 32px */
.m-10 { margin: 2.5rem; }   /* 40px */
.m-12 { margin: 3rem; }     /* 48px */
.m-16 { margin: 4rem; }     /* 64px */
.m-auto { margin: auto; }

/* Margin Top */
.mt-0 { margin-top: 0; }
.mt-1 { margin-top: 0.25rem; }
.mt-2 { margin-top: 0.5rem; }
.mt-3 { margin-top: 0.75rem; }
.mt-4 { margin-top: 1rem; }
.mt-6 { margin-top: 1.5rem; }
.mt-8 { margin-top: 2rem; }
.mt-12 { margin-top: 3rem; }

/* Margin Right */
.mr-0 { margin-right: 0; }
.mr-1 { margin-right: 0.25rem; }
.mr-2 { margin-right: 0.5rem; }
.mr-3 { margin-right: 0.75rem; }
.mr-4 { margin-right: 1rem; }
.mr-6 { margin-right: 1.5rem; }
.mr-8 { margin-right: 2rem; }
.mr-auto { margin-right: auto; }

/* Margin Bottom */
.mb-0 { margin-bottom: 0; }
.mb-1 { margin-bottom: 0.25rem; }
.mb-2 { margin-bottom: 0.5rem; }
.mb-3 { margin-bottom: 0.75rem; }
.mb-4 { margin-bottom: 1rem; }
.mb-6 { margin-bottom: 1.5rem; }
.mb-8 { margin-bottom: 2rem; }
.mb-12 { margin-bottom: 3rem; }

/* Margin Left */
.ml-0 { margin-left: 0; }
.ml-1 { margin-left: 0.25rem; }
.ml-2 { margin-left: 0.5rem; }
.ml-3 { margin-left: 0.75rem; }
.ml-4 { margin-left: 1rem; }
.ml-6 { margin-left: 1.5rem; }
.ml-8 { margin-left: 2rem; }
.ml-auto { margin-left: auto; }

/* Margin X-axis (horizontal) */
.mx-0 { margin-left: 0; margin-right: 0; }
.mx-1 { margin-left: 0.25rem; margin-right: 0.25rem; }
.mx-2 { margin-left: 0.5rem; margin-right: 0.5rem; }
.mx-4 { margin-left: 1rem; margin-right: 1rem; }
.mx-auto { margin-left: auto; margin-right: auto; }

/* Margin Y-axis (vertical) */
.my-0 { margin-top: 0; margin-bottom: 0; }
.my-1 { margin-top: 0.25rem; margin-bottom: 0.25rem; }
.my-2 { margin-top: 0.5rem; margin-bottom: 0.5rem; }
.my-4 { margin-top: 1rem; margin-bottom: 1rem; }
.my-8 { margin-top: 2rem; margin-bottom: 2rem; }

/* Padding */
.p-0 { padding: 0; }
.p-1 { padding: 0.25rem; }
.p-2 { padding: 0.5rem; }
.p-3 { padding: 0.75rem; }
.p-4 { padding: 1rem; }
.p-5 { padding: 1.25rem; }
.p-6 { padding: 1.5rem; }
.p-8 { padding: 2rem; }
.p-10 { padding: 2.5rem; }
.p-12 { padding: 3rem; }

/* Padding Top */
.pt-0 { padding-top: 0; }
.pt-1 { padding-top: 0.25rem; }
.pt-2 { padding-top: 0.5rem; }
.pt-4 { padding-top: 1rem; }
.pt-6 { padding-top: 1.5rem; }
.pt-8 { padding-top: 2rem; }

/* Padding Right */
.pr-0 { padding-right: 0; }
.pr-2 { padding-right: 0.5rem; }
.pr-4 { padding-right: 1rem; }
.pr-6 { padding-right: 1.5rem; }
.pr-8 { padding-right: 2rem; }

/* Padding Bottom */
.pb-0 { padding-bottom: 0; }
.pb-2 { padding-bottom: 0.5rem; }
.pb-4 { padding-bottom: 1rem; }
.pb-6 { padding-bottom: 1.5rem; }
.pb-8 { padding-bottom: 2rem; }

/* Padding Left */
.pl-0 { padding-left: 0; }
.pl-2 { padding-left: 0.5rem; }
.pl-4 { padding-left: 1rem; }
.pl-6 { padding-left: 1.5rem; }
.pl-8 { padding-left: 2rem; }

/* Padding X-axis */
.px-0 { padding-left: 0; padding-right: 0; }
.px-2 { padding-left: 0.5rem; padding-right: 0.5rem; }
.px-4 { padding-left: 1rem; padding-right: 1rem; }
.px-6 { padding-left: 1.5rem; padding-right: 1.5rem; }
.px-8 { padding-left: 2rem; padding-right: 2rem; }

/* Padding Y-axis */
.py-0 { padding-top: 0; padding-bottom: 0; }
.py-2 { padding-top: 0.5rem; padding-bottom: 0.5rem; }
.py-4 { padding-top: 1rem; padding-bottom: 1rem; }
.py-6 { padding-top: 1.5rem; padding-bottom: 1.5rem; }
.py-8 { padding-top: 2rem; padding-bottom: 2rem; }

/* Color Utilities
   ========================================================================== */

/* Background Colors */
.bg-white { background-color: #ffffff; }
.bg-gray-50 { background-color: #f9fafb; }
.bg-gray-100 { background-color: #f3f4f6; }
.bg-gray-200 { background-color: #e5e7eb; }
.bg-gray-300 { background-color: #d1d5db; }
.bg-gray-400 { background-color: #9ca3af; }
.bg-gray-500 { background-color: #6b7280; }
.bg-gray-600 { background-color: #4b5563; }
.bg-gray-700 { background-color: #374151; }
.bg-gray-800 { background-color: #1f2937; }
.bg-gray-900 { background-color: #111827; }
.bg-black { background-color: #000000; }

.bg-primary { background-color: #3b82f6; }
.bg-secondary { background-color: #6b7280; }
.bg-success { background-color: #10b981; }
.bg-danger { background-color: #ef4444; }
.bg-warning { background-color: #f59e0b; }
.bg-info { background-color: #3b82f6; }

.bg-transparent { background-color: transparent; }

/* Text Colors */
.text-white { color: #ffffff; }
.text-gray-50 { color: #f9fafb; }
.text-gray-100 { color: #f3f4f6; }
.text-gray-200 { color: #e5e7eb; }
.text-gray-300 { color: #d1d5db; }
.text-gray-400 { color: #9ca3af; }
.text-gray-500 { color: #6b7280; }
.text-gray-600 { color: #4b5563; }
.text-gray-700 { color: #374151; }
.text-gray-800 { color: #1f2937; }
.text-gray-900 { color: #111827; }
.text-black { color: #000000; }

.text-primary { color: #3b82f6; }
.text-secondary { color: #6b7280; }
.text-success { color: #10b981; }
.text-danger { color: #ef4444; }
.text-warning { color: #f59e0b; }
.text-info { color: #3b82f6; }

/* Flexbox Utilities
   ========================================================================== */

/* Display */
.flex { display: flex; }
.inline-flex { display: inline-flex; }

/* Flex Direction */
.flex-row { flex-direction: row; }
.flex-row-reverse { flex-direction: row-reverse; }
.flex-col { flex-direction: column; }
.flex-col-reverse { flex-direction: column-reverse; }

/* Flex Wrap */
.flex-wrap { flex-wrap: wrap; }
.flex-nowrap { flex-wrap: nowrap; }
.flex-wrap-reverse { flex-wrap: wrap-reverse; }

/* Justify Content */
.justify-start { justify-content: flex-start; }
.justify-end { justify-content: flex-end; }
.justify-center { justify-content: center; }
.justify-between { justify-content: space-between; }
.justify-around { justify-content: space-around; }
.justify-evenly { justify-content: space-evenly; }

/* Align Items */
.items-start { align-items: flex-start; }
.items-end { align-items: flex-end; }
.items-center { align-items: center; }
.items-baseline { align-items: baseline; }
.items-stretch { align-items: stretch; }

/* Align Self */
.self-auto { align-self: auto; }
.self-start { align-self: flex-start; }
.self-end { align-self: flex-end; }
.self-center { align-self: center; }
.self-stretch { align-self: stretch; }

/* Gap */
.gap-0 { gap: 0; }
.gap-1 { gap: 0.25rem; }
.gap-2 { gap: 0.5rem; }
.gap-3 { gap: 0.75rem; }
.gap-4 { gap: 1rem; }
.gap-6 { gap: 1.5rem; }
.gap-8 { gap: 2rem; }

/* Flex Grow/Shrink */
.flex-1 { flex: 1 1 0%; }
.flex-auto { flex: 1 1 auto; }
.flex-initial { flex: 0 1 auto; }
.flex-none { flex: none; }

.flex-grow { flex-grow: 1; }
.flex-grow-0 { flex-grow: 0; }

.flex-shrink { flex-shrink: 1; }
.flex-shrink-0 { flex-shrink: 0; }

/* Responsive Breakpoints
   ========================================================================== */

@media (min-width: 640px) {
  /* sm: spacing */
  .sm\:m-0 { margin: 0; }
  .sm\:m-4 { margin: 1rem; }
  .sm\:p-4 { padding: 1rem; }

  /* sm: flexbox */
  .sm\:flex { display: flex; }
  .sm\:flex-row { flex-direction: row; }
  .sm\:justify-center { justify-content: center; }
}

@media (min-width: 768px) {
  /* md: spacing */
  .md\:m-0 { margin: 0; }
  .md\:m-6 { margin: 1.5rem; }
  .md\:p-6 { padding: 1.5rem; }

  /* md: flexbox */
  .md\:flex { display: flex; }
  .md\:flex-row { flex-direction: row; }
  .md\:justify-between { justify-content: space-between; }
}

@media (min-width: 1024px) {
  /* lg: spacing */
  .lg\:m-0 { margin: 0; }
  .lg\:m-8 { margin: 2rem; }
  .lg\:p-8 { padding: 2rem; }

  /* lg: flexbox */
  .lg\:flex { display: flex; }
  .lg\:flex-row { flex-direction: row; }
  .lg\:gap-8 { gap: 2rem; }
}
```

---

## Complete Utility Categories

### 1. Spacing (Margin & Padding)
```css
/* Scale: 0, 1, 2, 3, 4, 5, 6, 8, 10, 12, 16, 20, 24 */
/* Directions: all, t, r, b, l, x, y */
.m-4    /* margin: 1rem */
.mt-2   /* margin-top: 0.5rem */
.px-4   /* padding-left/right: 1rem */
.my-8   /* margin-top/bottom: 2rem */
```

### 2. Typography
```css
/* Font Size */
.text-xs    { font-size: 0.75rem; }
.text-sm    { font-size: 0.875rem; }
.text-base  { font-size: 1rem; }
.text-lg    { font-size: 1.125rem; }
.text-xl    { font-size: 1.25rem; }
.text-2xl   { font-size: 1.5rem; }
.text-3xl   { font-size: 1.875rem; }
.text-4xl   { font-size: 2.25rem; }

/* Font Weight */
.font-thin       { font-weight: 100; }
.font-light      { font-weight: 300; }
.font-normal     { font-weight: 400; }
.font-medium     { font-weight: 500; }
.font-semibold   { font-weight: 600; }
.font-bold       { font-weight: 700; }
.font-extrabold  { font-weight: 800; }

/* Text Align */
.text-left    { text-align: left; }
.text-center  { text-align: center; }
.text-right   { text-align: right; }
.text-justify { text-align: justify; }

/* Line Height */
.leading-none    { line-height: 1; }
.leading-tight   { line-height: 1.25; }
.leading-normal  { line-height: 1.5; }
.leading-relaxed { line-height: 1.75; }
.leading-loose   { line-height: 2; }
```

### 3. Layout
```css
/* Display */
.block        { display: block; }
.inline       { display: inline; }
.inline-block { display: inline-block; }
.flex         { display: flex; }
.inline-flex  { display: inline-flex; }
.grid         { display: grid; }
.hidden       { display: none; }

/* Position */
.static    { position: static; }
.relative  { position: relative; }
.absolute  { position: absolute; }
.fixed     { position: fixed; }
.sticky    { position: sticky; }

/* Width */
.w-auto    { width: auto; }
.w-full    { width: 100%; }
.w-screen  { width: 100vw; }
.w-1\/2    { width: 50%; }
.w-1\/3    { width: 33.333333%; }
.w-1\/4    { width: 25%; }

/* Height */
.h-auto    { height: auto; }
.h-full    { height: 100%; }
.h-screen  { height: 100vh; }
```

### 4. Grid System
```css
/* Grid Template Columns */
.grid-cols-1  { grid-template-columns: repeat(1, minmax(0, 1fr)); }
.grid-cols-2  { grid-template-columns: repeat(2, minmax(0, 1fr)); }
.grid-cols-3  { grid-template-columns: repeat(3, minmax(0, 1fr)); }
.grid-cols-4  { grid-template-columns: repeat(4, minmax(0, 1fr)); }
.grid-cols-6  { grid-template-columns: repeat(6, minmax(0, 1fr)); }
.grid-cols-12 { grid-template-columns: repeat(12, minmax(0, 1fr)); }

/* Grid Gap */
.gap-0  { gap: 0; }
.gap-2  { gap: 0.5rem; }
.gap-4  { gap: 1rem; }
.gap-6  { gap: 1.5rem; }
.gap-8  { gap: 2rem; }
```

### 5. Borders & Radius
```css
/* Border Width */
.border-0 { border-width: 0; }
.border   { border-width: 1px; }
.border-2 { border-width: 2px; }
.border-4 { border-width: 4px; }

/* Border Radius */
.rounded-none { border-radius: 0; }
.rounded-sm   { border-radius: 0.125rem; }
.rounded      { border-radius: 0.25rem; }
.rounded-md   { border-radius: 0.375rem; }
.rounded-lg   { border-radius: 0.5rem; }
.rounded-xl   { border-radius: 0.75rem; }
.rounded-full { border-radius: 9999px; }

/* Border Color */
.border-gray-200 { border-color: #e5e7eb; }
.border-gray-300 { border-color: #d1d5db; }
.border-primary  { border-color: #3b82f6; }
```

### 6. Effects
```css
/* Shadow */
.shadow-none { box-shadow: none; }
.shadow-sm   { box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05); }
.shadow      { box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06); }
.shadow-md   { box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06); }
.shadow-lg   { box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05); }
.shadow-xl   { box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04); }

/* Opacity */
.opacity-0   { opacity: 0; }
.opacity-25  { opacity: 0.25; }
.opacity-50  { opacity: 0.5; }
.opacity-75  { opacity: 0.75; }
.opacity-100 { opacity: 1; }
```

---

## Usage Examples

### Example 1: Card Component
```html
<div class="bg-white rounded-lg shadow-md p-6 mb-4">
  <h2 class="text-2xl font-bold mb-2 text-gray-900">Card Title</h2>
  <p class="text-gray-600 mb-4">Card description goes here.</p>
  <button class="bg-primary text-white px-4 py-2 rounded">
    Action
  </button>
</div>
```

### Example 2: Flexbox Layout
```html
<div class="flex justify-between items-center p-4 bg-gray-50">
  <div class="flex items-center gap-2">
    <img src="logo.png" class="w-8 h-8" />
    <span class="font-semibold">Brand</span>
  </div>
  <nav class="flex gap-4">
    <a href="#" class="text-gray-700">Home</a>
    <a href="#" class="text-gray-700">About</a>
    <a href="#" class="text-gray-700">Contact</a>
  </nav>
</div>
```

### Example 3: Responsive Grid
```html
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 p-8">
  <div class="bg-white p-4 rounded shadow">Item 1</div>
  <div class="bg-white p-4 rounded shadow">Item 2</div>
  <div class="bg-white p-4 rounded shadow">Item 3</div>
</div>
```

---

## Customization Options

### Design Tokens Configuration

**design-tokens.json:**
```json
{
  "colors": {
    "primary": "#3b82f6",
    "secondary": "#6b7280",
    "success": "#10b981",
    "danger": "#ef4444",
    "warning": "#f59e0b"
  },
  "spacing": {
    "scale": [0, 4, 8, 12, 16, 20, 24, 32, 40, 48, 64]
  },
  "typography": {
    "fontSizes": {
      "xs": "0.75rem",
      "sm": "0.875rem",
      "base": "1rem",
      "lg": "1.125rem",
      "xl": "1.25rem",
      "2xl": "1.5rem"
    },
    "fontWeights": {
      "normal": 400,
      "medium": 500,
      "semibold": 600,
      "bold": 700
    }
  },
  "breakpoints": {
    "sm": "640px",
    "md": "768px",
    "lg": "1024px",
    "xl": "1280px"
  }
}
```

---

## Benefits

**1. No Build Step Required**
- Pure CSS, works immediately
- No JavaScript runtime
- No npm dependencies

**2. Familiar Syntax**
- Tailwind-like class names
- Easy to learn for Tailwind users
- Predictable naming conventions

**3. Customizable**
- Define your own design tokens
- Choose which categories to include
- Adjust spacing scales and breakpoints

**4. Lightweight**
- Generate only what you need
- ~10-50KB depending on categories
- Much smaller than full Tailwind

**5. Framework Agnostic**
- Works with React, Vue, vanilla HTML
- No framework lock-in
- Pure CSS solution

---

## Integration

### Add to HTML
```html
<link rel="stylesheet" href="utilities.css">
```

### Import in CSS
```css
@import url('utilities.css');
```

### Import in JavaScript
```javascript
import './utilities.css'
```

---

## Related Commands

- `/component-generator` - Generate React components using these utilities
- React Specialist (agent) - Component architecture guidance
- UI/UX Expert (agent) - Design system review

---

**Build your design system. Style faster. Ship consistent UIs.** 
