# Granola Skill Pack

> Claude Code skill pack for Granola AI meeting notes integration (24 skills)

## Installation

```bash
/plugin install granola-pack@claude-code-plugins-plus
```

## Skills Included

### Standard Skills (S01-S12)
| Skill | Description |
|-------|-------------|
| `granola-install-auth` | Install and configure Granola app with calendar integration |
| `granola-hello-world` | First meeting capture and notes review |
| `granola-local-dev-loop` | Local development workflow with Granola notes |
| `granola-sdk-patterns` | Zapier integration patterns and automation |
| `granola-core-workflow-a` | Meeting preparation and template setup |
| `granola-core-workflow-b` | Post-meeting note processing and sharing |
| `granola-common-errors` | Common Granola issues and solutions |
| `granola-debug-bundle` | Diagnostic bundle for troubleshooting |
| `granola-rate-limits` | Understanding usage limits and quotas |
| `granola-security-basics` | Security best practices for meeting data |
| `granola-prod-checklist` | Production readiness checklist |
| `granola-upgrade-migration` | Upgrade and plan migration guide |

### Pro Skills (P13-P18)
| Skill | Description |
|-------|-------------|
| `granola-ci-integration` | CI/CD integration with Zapier workflows |
| `granola-deploy-integration` | Deploy integrations to Slack, Notion, HubSpot |
| `granola-webhooks-events` | Zapier webhook event handling |
| `granola-performance-tuning` | Optimize transcription and note quality |
| `granola-cost-tuning` | Cost optimization and plan selection |
| `granola-reference-architecture` | Enterprise meeting workflow architecture |

### Flagship Skills (F19-F24)
| Skill | Description |
|-------|-------------|
| `granola-multi-env-setup` | Multi-workspace and team configuration |
| `granola-observability` | Meeting analytics and insights tracking |
| `granola-incident-runbook` | Incident response for meeting capture issues |
| `granola-data-handling` | Data export, retention, and GDPR compliance |
| `granola-enterprise-rbac` | Enterprise role-based access control |
| `granola-migration-deep-dive` | Migration from other note-taking tools |

## Usage

Skills trigger automatically when you discuss Granola topics. For example:

- "Help me set up Granola" triggers `granola-install-auth`
- "Debug Granola not recording" triggers `granola-common-errors`
- "Export my Granola notes to Notion" triggers `granola-deploy-integration`

## About Granola

Granola is an AI-powered meeting notes app that:
- Captures audio directly from your device (no bot joins meetings)
- Automatically transcribes and summarizes meetings
- Allows live note-taking enhanced with transcript context
- Integrates with Slack, Notion, HubSpot, and 8,000+ apps via Zapier

## License

MIT
