# Juicebox Skill Pack

> Claude Code skill pack for Juicebox integration (24 skills)

Juicebox is an AI-powered people search and recruiting platform that helps teams find and connect with professionals.

## Installation

```bash
/plugin install juicebox-pack@claude-code-plugins-plus
```

## Skills Included

### Standard Skills (S01-S12)
| Skill | Description |
|-------|-------------|
| `juicebox-install-auth` | Install and configure Juicebox SDK/CLI authentication |
| `juicebox-hello-world` | Create a minimal working Juicebox example |
| `juicebox-local-dev-loop` | Configure Juicebox local development workflow |
| `juicebox-sdk-patterns` | Apply production-ready Juicebox SDK patterns |
| `juicebox-core-workflow-a` | Execute Juicebox people search workflow |
| `juicebox-core-workflow-b` | Implement Juicebox candidate enrichment workflow |
| `juicebox-common-errors` | Diagnose and fix Juicebox common errors |
| `juicebox-debug-bundle` | Collect Juicebox debug evidence for support |
| `juicebox-rate-limits` | Implement Juicebox rate limiting and backoff |
| `juicebox-security-basics` | Apply Juicebox security best practices |
| `juicebox-prod-checklist` | Execute Juicebox production deployment checklist |
| `juicebox-upgrade-migration` | Plan and execute Juicebox SDK upgrades |

### Pro Skills (P13-P18)
| Skill | Description |
|-------|-------------|
| `juicebox-ci-integration` | Configure Juicebox CI/CD integration |
| `juicebox-deploy-integration` | Deploy Juicebox integrations to production |
| `juicebox-webhooks-events` | Implement Juicebox webhook handling |
| `juicebox-performance-tuning` | Optimize Juicebox API performance |
| `juicebox-cost-tuning` | Optimize Juicebox costs and usage |
| `juicebox-reference-architecture` | Implement Juicebox reference architecture |

### Flagship Skills (F19-F24)
| Skill | Description |
|-------|-------------|
| `juicebox-multi-env-setup` | Configure Juicebox multi-environment setup |
| `juicebox-observability` | Set up Juicebox monitoring and observability |
| `juicebox-incident-runbook` | Execute Juicebox incident response procedures |
| `juicebox-data-handling` | Implement Juicebox data privacy and handling |
| `juicebox-enterprise-rbac` | Configure Juicebox enterprise role-based access |
| `juicebox-migration-deep-dive` | Advanced Juicebox data migration strategies |

## Usage

Skills trigger automatically when you discuss Juicebox topics. For example:

- "Help me set up Juicebox" triggers `juicebox-install-auth`
- "Debug this Juicebox error" triggers `juicebox-common-errors`
- "Search for candidates with Juicebox" triggers `juicebox-core-workflow-a`
- "Deploy my Juicebox integration" triggers `juicebox-deploy-integration`

## License

MIT
