# Obsidian Skill Pack

> Claude Code skill pack for Obsidian plugin development and vault management (24 skills)

## Installation

```bash
/plugin install obsidian-pack@claude-code-plugins-plus
```

## Skills Included

### Standard Skills (S01-S12)
| Skill | Description |
|-------|-------------|
| `obsidian-install-auth` | Set up Obsidian plugin development environment |
| `obsidian-hello-world` | Create your first Obsidian plugin |
| `obsidian-local-dev-loop` | Configure hot-reload development workflow |
| `obsidian-sdk-patterns` | Production-ready plugin code patterns |
| `obsidian-core-workflow-a` | Note manipulation and vault operations |
| `obsidian-core-workflow-b` | UI components and modals |
| `obsidian-common-errors` | Diagnose and fix common plugin errors |
| `obsidian-debug-bundle` | Collect diagnostic information for support |
| `obsidian-rate-limits` | Handle file system and API throttling |
| `obsidian-security-basics` | Secure plugin development practices |
| `obsidian-prod-checklist` | Pre-release plugin verification |
| `obsidian-upgrade-migration` | Migrate plugins between Obsidian versions |

### Pro Skills (P13-P18)
| Skill | Description |
|-------|-------------|
| `obsidian-ci-integration` | GitHub Actions for plugin builds |
| `obsidian-deploy-integration` | Publish to Obsidian community plugins |
| `obsidian-webhooks-events` | Event handling and workspace callbacks |
| `obsidian-performance-tuning` | Optimize plugin performance |
| `obsidian-cost-tuning` | Resource usage optimization |
| `obsidian-reference-architecture` | Best-practice plugin project layout |

### Flagship Skills (F19-F24)
| Skill | Description |
|-------|-------------|
| `obsidian-multi-env-setup` | Development, testing, production vaults |
| `obsidian-observability` | Plugin monitoring and logging |
| `obsidian-incident-runbook` | Troubleshoot plugin failures |
| `obsidian-data-handling` | Vault data backup and sync strategies |
| `obsidian-enterprise-rbac` | Team vault access patterns |
| `obsidian-migration-deep-dive` | Major plugin rewrites and migrations |

## Usage

Skills trigger automatically when you discuss Obsidian topics. For example:

- "Help me set up Obsidian plugin development" -> triggers `obsidian-install-auth`
- "Debug this Obsidian plugin error" -> triggers `obsidian-common-errors`
- "Publish my plugin to community plugins" -> triggers `obsidian-deploy-integration`

## License

MIT
