# OpenRouter Skill Pack

> Flagship+ tier: 30 comprehensive skills for OpenRouter LLM gateway mastery

## Overview

Complete Claude Code skill pack for [OpenRouter](https://openrouter.ai) - the unified API for 100+ LLM models. Covers multi-model routing, automatic fallbacks, cost optimization, and production integration.

## Installation

```bash
# Via Claude Code
/plugin install openrouter-pack@claude-code-plugins-plus

# Via npm
npm install @intentsolutionsio/openrouter-skill-md-pack
```

## Skills Included (30)

### Onboarding & Foundations (6 skills)
- **openrouter-install-auth** - API key setup and authentication
- **openrouter-hello-world** - First API request and response
- **openrouter-model-catalog** - Browsing and selecting models
- **openrouter-sdk-patterns** - SDK usage patterns (Python, TypeScript)
- **openrouter-openai-compat** - OpenAI SDK compatibility mode
- **openrouter-pricing-basics** - Understanding model pricing

### Operations & Debugging (6 skills)
- **openrouter-common-errors** - Common issues and fixes
- **openrouter-debug-bundle** - Request/response debugging
- **openrouter-rate-limits** - Rate limit handling
- **openrouter-model-availability** - Model status and availability
- **openrouter-prod-checklist** - Production readiness checklist
- **openrouter-upgrade-migration** - API version migrations

### CI/CD & Deployment (6 skills)
- **openrouter-fallback-config** - Automatic fallback configuration
- **openrouter-routing-rules** - Model routing strategies
- **openrouter-streaming-setup** - Streaming response setup
- **openrouter-caching-strategy** - Response caching patterns
- **openrouter-load-balancing** - Multi-key load distribution
- **openrouter-reference-architecture** - Reference architecture patterns

### Enterprise & Compliance (6 skills)
- **openrouter-team-setup** - Team and organization setup
- **openrouter-cost-controls** - Budget limits and alerts
- **openrouter-usage-analytics** - Usage tracking and reporting
- **openrouter-data-privacy** - Data handling and privacy
- **openrouter-audit-logging** - Audit trail configuration
- **openrouter-compliance-review** - Compliance considerations

### Advanced Patterns (6 skills)
- **openrouter-model-routing** - Advanced routing strategies
- **openrouter-function-calling** - Tool/function calling patterns
- **openrouter-context-optimization** - Context window optimization
- **openrouter-multi-provider** - Multi-provider strategies
- **openrouter-performance-tuning** - Latency and throughput optimization
- **openrouter-known-pitfalls** - Common pitfalls and solutions

## Quick Start

After installation, these skills activate automatically when you:
- Set up OpenRouter API integration
- Configure model fallbacks
- Optimize LLM costs
- Debug API requests
- Implement streaming responses

## Links

- [OpenRouter Documentation](https://openrouter.ai/docs)
- [OpenRouter Dashboard](https://openrouter.ai/keys)
- [Plugin Marketplace](https://claudecodeplugins.io)

## License

MIT
