---
name: roi
description: Calculate automation ROI
---
# ROI Calculator

Calculate and present compelling ROI for AI automation projects.

## ROI Calculation Framework

### Current State Costs (Annual)
```
Labor Costs:
- Hours per week: [X]
- Hourly rate: $[X]
- Annual cost: Hours × Rate × 52 = $[X]

Error Costs:
- Error rate: [X]%
- Cost per error: $[X]
- Annual error cost: $[X]

Opportunity Costs:
- Lost revenue due to delays: $[X]
- Missed opportunities: $[X]

Total Annual Cost: $[X]
```

### Automation Solution
```
Implementation Costs:
- Agency fees: $[X]
- Software licenses: $[X]/year
- Training: $[X]
- Total implementation: $[X]

Annual Operating Costs:
- Software licenses: $[X]
- API costs: $[X]
- Maintenance: $[X]
- Total annual operating: $[X]
```

### ROI Calculation
```
Time Savings:
- Current time: [X] hours/week
- After automation: [X] hours/week
- Time saved: [X] hours/week
- Annual hours saved: [X] × 52 = [X]
- Value of time saved: [X] × $[rate] = $[X]

Quality Improvements:
- Error reduction: [X]%
- Annual error savings: $[X]

Speed Improvements:
- Faster processing: [X]%
- Additional capacity: $[X]

Total Annual Benefit: $[X]
Net Annual Benefit: $[X] - $[X] operating = $[X]

ROI: (Net Benefit / Implementation Cost) × 100 = [X]%
Payback Period: Implementation Cost / Net Annual Benefit = [X] months
```

## ROI Presentation Template

```markdown
# ROI Analysis: [Project Name]

## Executive Summary
By implementing [solution], [Company] will save **$X per year** with an ROI of **X%** and payback period of **X months**.

## Current State Analysis

### Time Investment
Currently, your team spends:
- **X hours per week** on [process]
- **X hours per year** total
- **$X per year** in labor costs (at $X/hour)

### Quality Issues
- **X% error rate** costing approximately **$X per error**
- **$X per year** in rework and corrections

### Opportunity Cost
- **X hours per week** that could be spent on higher-value work
- Estimated **$X in missed revenue** due to capacity constraints

**Total Current Annual Cost: $X**

## Proposed Solution

### Implementation
- Development: $X
- Integration: $X
- Training: $X
**Total Implementation: $X**

### Annual Operating Costs
- Software licenses: $X/year
- API usage: $X/year
- Maintenance: $X/year
**Total Annual Operating: $X/year**

## Expected Benefits

### Time Savings
- **Reduce process time by X%**
- **Save X hours per week**
- **$X value of time savings per year**

### Quality Improvements
- **Reduce errors by X%**
- **Save $X per year in error costs**

### Capacity Gains
- **Free up X% of team capacity**
- **Enable $X in additional revenue**

**Total Annual Benefit: $X**

## ROI Summary

| Metric | Value |
|--------|-------|
| Implementation Cost | $X |
| Annual Operating Cost | $X |
| Annual Benefit | $X |
| Net Annual Benefit | $X |
| **ROI** | **X%** |
| **Payback Period** | **X months** |
| **3-Year Value** | **$X** |

## Comparison: Do Nothing vs Automate

### Year 1
- Do Nothing: Lose $X in inefficiency
- Automate: Invest $X, gain $X → Net $X

### Year 2
- Do Nothing: Lose $X (cumulative $X)
- Automate: Gain $X (cumulative $X)

### Year 3
- Do Nothing: Lose $X (cumulative $X)
- Automate: Gain $X (cumulative $X)

**3-Year Difference: $X**

## Risk Mitigation
- Phased implementation reduces risk
- 30-day warranty included
- Ongoing support available
- Proven technology stack

## Next Steps
1. Approve project scope
2. Begin implementation (Week 1)
3. See first results (Week 8)
4. Full ROI realized (Month X)
```

## Industry-Specific ROI Examples

### Customer Support Automation
```
Before: 1000 tickets/month, 15 min average = 250 hours
After: 60% automated, 100 hours saved
Savings: 150 hours × $35/hour = $5,250/month
Annual: $63,000
Implementation: $25,000
ROI: 252% (4-month payback)
```

### Content Generation
```
Before: 10 posts/week, 2 hours each = 20 hours/week
After: AI generates drafts, 30 min review = 5 hours/week
Savings: 15 hours × $75/hour = $1,125/week
Annual: $58,500
Implementation: $15,000
ROI: 390% (3-month payback)
```

### Lead Qualification
```
Before: 500 leads/month, 10 min each = 83 hours
After: AI scores leads, review top 20% = 17 hours
Savings: 66 hours × $50/hour = $3,300/month
Plus: 25% increase in qualified leads = $10,000/month
Annual: $159,600
Implementation: $20,000
ROI: 798% (1.5-month payback)
```

Use this calculator to build compelling business cases for AI automation projects.
