---
name: audit-report
description: Generate comprehensive security audit report
shortcut: audi
---
# Security Audit Reporter

Generate comprehensive security audit reports covering vulnerabilities, compliance status, and remediation roadmap.

## Report Components

1. **Executive Summary**
   - Overall security posture
   - Critical findings count
   - Risk score and trend analysis
   - Business impact assessment

2. **Vulnerability Assessment**
   - All identified vulnerabilities
   - CVSS scores and severity ratings
   - Affected systems and components
   - Exploitation likelihood

3. **Compliance Status**
   - OWASP Top 10 coverage
   - Regulatory compliance (GDPR, HIPAA, PCI-DSS, SOC2)
   - Industry standards adherence
   - Gap analysis

4. **Security Controls**
   - Authentication mechanisms
   - Authorization controls
   - Encryption implementation
   - Logging and monitoring
   - Incident response readiness

5. **Remediation Roadmap**
   - Prioritized fix list
   - Effort estimates
   - Implementation timeline
   - Resource requirements

## Report Formats

- **PDF** - Executive presentations
- **HTML** - Interactive dashboards
- **JSON** - Automated processing
- **Markdown** - Documentation

## Audit Scope

The audit covers:
- Application security
- Infrastructure security
- Network security
- Data security
- Access control
- Compliance requirements
- Security policies
- Incident response procedures

## Best Practices

- Run quarterly security audits
- Track remediation progress
- Share with stakeholders
- Maintain audit history
- Update security policies based on findings
