# Implementation Guide

### Step 1: Install SDK
```bash
# Node.js
npm install @sentry/node

# Browser/React
npm install @sentry/react

# Python
pip install sentry-sdk
```

### Step 2: Configure DSN
```bash
# Set environment variable
export SENTRY_DSN="https://key@org.ingest.sentry.io/project"

# Or create .env file
echo 'SENTRY_DSN=https://key@org.ingest.sentry.io/project' >> .env
```

### Step 3: Initialize Sentry
```typescript
import * as Sentry from '@sentry/node';

Sentry.init({
  dsn: process.env.SENTRY_DSN,
  environment: process.env.NODE_ENV,
  tracesSampleRate: 1.0,
});
```

### Step 4: Verify Connection
```typescript
Sentry.captureMessage('Sentry test message');
console.log('Check Sentry dashboard for test message');
```