---
name: sentry-performance-tracing
description: |
  Execute set up performance monitoring and distributed tracing with Sentry.
  Use when implementing performance tracking, tracing requests,
  or monitoring application performance.
  Trigger with phrases like "sentry performance", "sentry tracing",
  "sentry APM", "monitor performance sentry".
allowed-tools: Read, Write, Edit, Grep
version: 1.0.0
license: MIT
author: Jeremy Longshore <jeremy@intentsolutions.io>
---

# Sentry Performance Tracing

## Prerequisites
- Sentry SDK installed
- Performance plan enabled in Sentry
- Understanding of tracing concepts


See `{baseDir}/references/implementation.md` for detailed implementation guide.

## Output
- Performance data visible in Sentry Performance dashboard
- Distributed traces across services
- Span breakdowns for bottleneck identification

## Error Handling

See `{baseDir}/references/errors.md` for comprehensive error handling.

## Examples

See `{baseDir}/references/examples.md` for detailed examples.

## Resources
- [Sentry Performance](https://docs.sentry.io/product/performance/)
- [Distributed Tracing](https://docs.sentry.io/product/performance/distributed-tracing/)
