---
name: vercel-sdk-patterns
description: |
  Execute apply production-ready Vercel SDK patterns for TypeScript and Python.
  Use when implementing Vercel integrations, refactoring SDK usage,
  or establishing team coding standards for Vercel.
  Trigger with phrases like "vercel SDK patterns", "vercel best practices",
  "vercel code patterns", "idiomatic vercel".
allowed-tools: Read, Write, Edit
version: 1.0.0
license: MIT
author: Jeremy Longshore <jeremy@intentsolutions.io>
---

# Vercel Sdk Patterns

## Prerequisites
- Completed `vercel-install-auth` setup
- Familiarity with async/await patterns
- Understanding of error handling best practices


See `{baseDir}/references/implementation.md` for detailed implementation guide.

## Output
- Type-safe client singleton
- Robust error handling with structured logging
- Automatic retry with exponential backoff
- Runtime validation for API responses

## Error Handling

See `{baseDir}/references/errors.md` for comprehensive error handling.

## Examples

See `{baseDir}/references/examples.md` for detailed examples.

## Resources
- [Vercel SDK Reference](https://vercel.com/docs/sdk)
- [Vercel API Types](https://vercel.com/docs/types)
- [Zod Documentation](https://zod.dev/)
