# SEO Meta Tags for Web to GitHub Issue Plugin

**Last Updated:** 2025-10-16

## Page: /plugins/web-to-github-issue

### Title Tag (58 chars)
```
Web to GitHub Issue - Claude AI Research Automation Plugin
```

### Meta Description (158 chars)
```
Free Claude Code plugin that converts AI research into formatted GitHub issues automatically. Save 95% time creating tickets with sources and action items.
```

### Canonical URL
```html
<link rel="canonical" href="https://claudecodeplugins.io/plugins/web-to-github-issue" />
```

### Open Graph Tags
```html
<!-- Open Graph / Facebook -->
<meta property="og:type" content="article" />
<meta property="og:url" content="https://claudecodeplugins.io/plugins/web-to-github-issue" />
<meta property="og:title" content="Web to GitHub Issue - Claude AI Research Automation Plugin" />
<meta property="og:description" content="Free Claude Code plugin that converts AI research into formatted GitHub issues automatically. Save 95% time creating tickets with sources and action items." />
<meta property="og:image" content="https://claudecodeplugins.io/images/plugins/web-to-github-issue-og.png" />
<meta property="og:image:width" content="1200" />
<meta property="og:image:height" content="630" />
<meta property="og:site_name" content="Claude Code Plugins" />
<meta property="og:locale" content="en_US" />
<meta property="article:published_time" content="2025-10-16T00:00:00Z" />
<meta property="article:modified_time" content="2025-10-16T00:00:00Z" />
<meta property="article:author" content="Jeremy Longshore" />
<meta property="article:section" content="Skill Enhancers" />
<meta property="article:tag" content="automation" />
<meta property="article:tag" content="GitHub" />
<meta property="article:tag" content="research" />
```

### Twitter Card Tags
```html
<!-- Twitter -->
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:site" content="@jeremylongshore" />
<meta name="twitter:creator" content="@jeremylongshore" />
<meta name="twitter:url" content="https://claudecodeplugins.io/plugins/web-to-github-issue" />
<meta name="twitter:title" content="Web to GitHub Issue - Claude AI Research Automation" />
<meta name="twitter:description" content="Free plugin: Claude research → GitHub issues automatically. Save 15 min per ticket with formatted sources and action items." />
<meta name="twitter:image" content="https://claudecodeplugins.io/images/plugins/web-to-github-issue-twitter.png" />
<meta name="twitter:image:alt" content="Web to GitHub Issue plugin demo showing Claude research converted to formatted GitHub issue" />
```

### Additional Meta Tags
```html
<!-- Additional SEO -->
<meta name="keywords" content="Claude GitHub automation, AI research to GitHub, automated GitHub issues, Claude Code plugin, web search to ticket, research automation, developer productivity, GitHub issue creator" />
<meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1" />
<meta name="author" content="Jeremy Longshore" />
<meta name="theme-color" content="#8b5cf6" />

<!-- Language -->
<link rel="alternate" hreflang="en" href="https://claudecodeplugins.io/plugins/web-to-github-issue" />

<!-- Software Application -->
<meta itemprop="name" content="Web to GitHub Issue" />
<meta itemprop="description" content="Converts Claude's web research into actionable GitHub issues automatically" />
<meta itemprop="applicationCategory" content="DeveloperApplication" />
<meta itemprop="operatingSystem" content="Cross-platform" />
<meta itemprop="price" content="0" />
<meta itemprop="priceCurrency" content="USD" />
```

### Astro Frontmatter Format
```typescript
---
import Layout from '../../../layouts/Layout.astro';
import PluginLayout from '../../../layouts/PluginLayout.astro';

const seo = {
  title: "Web to GitHub Issue - Claude AI Research Automation Plugin",
  description: "Free Claude Code plugin that converts AI research into formatted GitHub issues automatically. Save 95% time creating tickets with sources and action items.",
  canonical: "https://claudecodeplugins.io/plugins/web-to-github-issue",
  keywords: "Claude GitHub automation, AI research to GitHub, automated GitHub issues, Claude Code plugin, web search to ticket, research automation, developer productivity, GitHub issue creator",
  ogImage: "https://claudecodeplugins.io/images/plugins/web-to-github-issue-og.png",
  twitterImage: "https://claudecodeplugins.io/images/plugins/web-to-github-issue-twitter.png",
  twitterCard: "summary_large_image",
  author: "Jeremy Longshore",
  type: "article",
  category: "skill-enhancers",
  publishedTime: "2025-10-16T00:00:00Z",
  modifiedTime: "2025-10-16T00:00:00Z"
};

const plugin = {
  name: "web-to-github-issue",
  displayName: "Web to GitHub Issue",
  version: "1.0.0",
  category: "skill-enhancers",
  free: true,
  featured: true
};
---
```

## Schema.org JSON-LD Markup

### SoftwareApplication Schema
```json
{
  "@context": "https://schema.org",
  "@type": "SoftwareApplication",
  "name": "Web to GitHub Issue",
  "description": "Claude Code plugin that converts AI web research into formatted GitHub issues automatically with sources, key findings, and action items",
  "applicationCategory": "DeveloperApplication",
  "operatingSystem": "Cross-platform",
  "softwareVersion": "1.0.0",
  "datePublished": "2025-10-16",
  "dateModified": "2025-10-16",
  "author": {
    "@type": "Person",
    "name": "Jeremy Longshore",
    "url": "https://github.com/jeremylongshore"
  },
  "publisher": {
    "@type": "Organization",
    "name": "Claude Code Plugins",
    "url": "https://claudecodeplugins.io"
  },
  "offers": {
    "@type": "Offer",
    "price": "0",
    "priceCurrency": "USD",
    "availability": "https://schema.org/InStock",
    "url": "https://claudecodeplugins.io/plugins/web-to-github-issue"
  },
  "aggregateRating": {
    "@type": "AggregateRating",
    "ratingValue": "5.0",
    "ratingCount": "1",
    "bestRating": "5",
    "worstRating": "1"
  },
  "screenshot": "https://claudecodeplugins.io/images/plugins/web-to-github-issue-screenshot.png",
  "downloadUrl": "https://github.com/jeremylongshore/claude-code-plugins/tree/main/plugins/skill-enhancers/web-to-github-issue",
  "installUrl": "claudecode://install/web-to-github-issue@claude-code-plugins-plus",
  "featureList": [
    "Automatic research extraction from Claude web_search Skill",
    "Smart GitHub issue formatting with markdown",
    "Source URL preservation and citation",
    "Priority detection (normal/urgent) from content",
    "Action checklist generation",
    "Topic tagging and categorization",
    "Configurable repository targeting",
    "Label and assignee support",
    "Natural language interface"
  ],
  "requirements": "Claude Code CLI, GitHub Personal Access Token with repo scope, Node.js 18+",
  "softwareHelp": {
    "@type": "WebPage",
    "url": "https://claudecodeplugins.io/docs/web-to-github-issue"
  },
  "applicationSubCategory": "Automation, Productivity, Research Tools",
  "keywords": "GitHub automation, Claude AI, research to issue, developer productivity, ticket automation, web search automation",
  "isAccessibleForFree": true,
  "license": "https://opensource.org/licenses/MIT"
}
```

### HowTo Schema (Installation Instructions)
```json
{
  "@context": "https://schema.org",
  "@type": "HowTo",
  "name": "How to Install Web to GitHub Issue Plugin",
  "description": "Step-by-step guide to install and configure the Web to GitHub Issue Claude Code plugin",
  "image": "https://claudecodeplugins.io/images/plugins/web-to-github-issue-install.png",
  "estimatedCost": {
    "@type": "MonetaryAmount",
    "currency": "USD",
    "value": "0"
  },
  "totalTime": "PT5M",
  "tool": [
    {
      "@type": "HowToTool",
      "name": "Claude Code CLI"
    },
    {
      "@type": "HowToTool",
      "name": "GitHub Account"
    }
  ],
  "supply": [
    {
      "@type": "HowToSupply",
      "name": "GitHub Personal Access Token"
    }
  ],
  "step": [
    {
      "@type": "HowToStep",
      "position": 1,
      "name": "Add Marketplace",
      "text": "Add the Claude Code Plugins marketplace to your CLI",
      "itemListElement": {
        "@type": "HowToDirection",
        "text": "/plugin marketplace add jeremylongshore/claude-code-plugins"
      }
    },
    {
      "@type": "HowToStep",
      "position": 2,
      "name": "Install Plugin",
      "text": "Install the web-to-github-issue plugin from the marketplace",
      "itemListElement": {
        "@type": "HowToDirection",
        "text": "/plugin install web-to-github-issue@claude-code-plugins-plus"
      }
    },
    {
      "@type": "HowToStep",
      "position": 3,
      "name": "Configure GitHub Token",
      "text": "Set your GitHub Personal Access Token as an environment variable",
      "itemListElement": {
        "@type": "HowToDirection",
        "text": "export GITHUB_TOKEN=ghp_your_token_here"
      }
    },
    {
      "@type": "HowToStep",
      "position": 4,
      "name": "Use the Plugin",
      "text": "Ask Claude to research a topic and create a GitHub issue",
      "itemListElement": {
        "@type": "HowToDirection",
        "text": "claude: \"research PostgreSQL indexing best practices and create a ticket in myorg/backend\""
      }
    }
  ]
}
```

### FAQPage Schema (Troubleshooting)
```json
{
  "@context": "https://schema.org",
  "@type": "FAQPage",
  "mainEntity": [
    {
      "@type": "Question",
      "name": "How does the Web to GitHub Issue plugin work?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "The plugin intercepts results from Claude's web_search Skill, extracts key findings and sources, formats them into a structured markdown document, and creates a GitHub issue via the GitHub API with all citations preserved."
      }
    },
    {
      "@type": "Question",
      "name": "What information is included in generated GitHub issues?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Generated issues include: research summary, key findings with source citations, priority level (normal/urgent), related topic tags, all source URLs with descriptions, and a next steps checklist for action items."
      }
    },
    {
      "@type": "Question",
      "name": "Do I need a GitHub Personal Access Token?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Yes, you need a GitHub Personal Access Token with 'repo' scope. Create one at https://github.com/settings/tokens/new and set it as the GITHUB_TOKEN environment variable."
      }
    },
    {
      "@type": "Question",
      "name": "Can I specify which repository to create issues in?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Yes, you can specify the repository in your command (e.g., '--repo owner/repo') or set a default repository using the GITHUB_DEFAULT_REPO environment variable."
      }
    },
    {
      "@type": "Question",
      "name": "How much time does this plugin save?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "The plugin saves approximately 95% of time compared to manual issue creation. Manual process takes 10-15 minutes (research, format, create issue, add sources), while the plugin completes the same task in 30 seconds."
      }
    },
    {
      "@type": "Question",
      "name": "Is the Web to GitHub Issue plugin free?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Yes, this plugin is completely free and open source under the MIT license. It's part of the Community tier of Claude Code Plugins."
      }
    },
    {
      "@type": "Question",
      "name": "What if Claude doesn't find relevant search results?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "If web search returns no results, try broader search terms, check your internet connectivity, and verify that the web_search Skill is available in your Claude Code instance."
      }
    }
  ]
}
```

### Breadcrumb Schema
```json
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "https://claudecodeplugins.io"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "Plugins",
      "item": "https://claudecodeplugins.io/plugins"
    },
    {
      "@type": "ListItem",
      "position": 3,
      "name": "Skill Enhancers",
      "item": "https://claudecodeplugins.io/categories/skill-enhancers"
    },
    {
      "@type": "ListItem",
      "position": 4,
      "name": "Web to GitHub Issue",
      "item": "https://claudecodeplugins.io/plugins/web-to-github-issue"
    }
  ]
}
```

## Primary Keywords

**Target Keywords:**
- Claude GitHub automation (Primary - Low competition)
- AI research to GitHub issue (Primary - Very low competition)
- Automated GitHub issue creator (Secondary - Medium competition)
- Claude Code plugin GitHub (Secondary - Low competition)
- Web search to GitHub ticket (Tertiary - Very low competition)

**Long-Tail Keywords:**
- How to automate GitHub issues with Claude AI
- Convert web research to GitHub tickets
- Claude plugin for GitHub automation
- AI-powered GitHub issue creation
- Research automation for developers

**Semantic Keywords:**
- Developer productivity tools
- GitHub workflow automation
- AI research assistant
- Ticket management automation
- Source citation in GitHub issues
- Developer time-saving tools

## Content Optimization Strategy

### H1 Tag (Primary Keyword)
```html
<h1>Web to GitHub Issue: Automate Research with Claude AI</h1>
```

### H2 Headings (Keyword Distribution)
```html
<h2>What It Does: Claude Research → GitHub Issues</h2>
<h2>Real Use Cases for GitHub Automation</h2>
<h2>Installation: 3-Step Setup</h2>
<h2>How to Use: Natural Language Commands</h2>
<h2>Generated Issue Format: Professional and Complete</h2>
<h2>Features: Smart Automation for Developers</h2>
<h2>Configuration Options for GitHub Integration</h2>
<h2>How the Plugin Works: Behind the Scenes</h2>
<h2>Why Use This Plugin vs Manual Process</h2>
<h2>Requirements: GitHub Token and Claude Code</h2>
<h2>Troubleshooting Common Issues</h2>
<h2>Related Plugins: Skill Enhancers Collection</h2>
```

### Optimized Introduction (First 150 words)
```markdown
# Web to GitHub Issue: Automate Research with Claude AI

**Free Skill Enhancer Plugin** that transforms Claude's web research into
professional GitHub issues automatically. Save 95% of time creating tickets
by eliminating manual copy-paste workflows.

This Claude Code plugin bridges the gap between AI-powered research and
actionable development tasks. When Claude uses its web_search Skill to find
information, the Web to GitHub Issue plugin automatically extracts key findings,
formats them with markdown, preserves all source citations, and creates a
complete GitHub issue ready for your team.

**The automated workflow:**
1. Ask Claude to research any topic
2. Plugin extracts findings and sources
3. Formatted GitHub issue created automatically
4. Team can act on research immediately

Perfect for technical research, security monitoring, feature investigation,
and competitive analysis. Free, open source, and takes 5 minutes to install.

[Install Now →](#installation)
```

### Before/After Comparison (SEO + Conversion)
```markdown
## Why Use This Plugin vs Manual Process

### Without Web to GitHub Issue Plugin ❌

**Time Required: 10-15 minutes per issue**

1. Ask Claude to research topic (2 min)
2. Read through search results (3 min)
3. Copy relevant findings to notes (2 min)
4. Open GitHub in browser (30 sec)
5. Navigate to repository (30 sec)
6. Click "New Issue" button (10 sec)
7. Format markdown manually (3 min)
8. Copy/paste source URLs (2 min)
9. Add labels and assignees (1 min)
10. Double-check formatting (1 min)

**Result:** Issue created, but significant context switching and manual work

### With Web to GitHub Issue Plugin ✅

**Time Required: 30 seconds**

1. Ask Claude: "research PostgreSQL indexing and create ticket in myorg/backend"

**Result:** Professional GitHub issue with:
- Research summary
- Key findings with citations
- All source URLs preserved
- Next steps checklist
- Automatic priority detection
- Related topic tags

**Time Saved: 95%** (14.5 minutes per issue)
**Focus Saved:** Zero context switching, stay in Claude
**Quality Gained:** Consistent formatting, never forget sources
```

## Call-to-Action Optimization

### Primary CTA (Above the fold)
```html
<div class="cta-banner">
  <h3>Ready to Automate Your GitHub Workflow?</h3>
  <p>Install in 5 minutes. Free forever. Save 95% time per issue.</p>
  <a href="#installation" class="cta-primary">
    Install Web to GitHub Issue →
  </a>
</div>
```

### Secondary CTA (After use cases)
```html
<div class="cta-inline">
  <p>See how it works? <a href="#how-it-works">Learn more about the automation</a> or <a href="#installation">install now</a>.</p>
</div>
```

### Tertiary CTA (Bottom of page)
```html
<div class="cta-footer">
  <h3>Explore More Skill Enhancers</h3>
  <p>Web to GitHub Issue is part of our Skill Enhancers collection.</p>
  <a href="/categories/skill-enhancers" class="cta-tertiary">
    Browse All Skill Enhancer Plugins →
  </a>
  <a href="/sponsor" class="cta-tertiary-alt">
    Get Pro Access for Premium Plugins →
  </a>
</div>
```

## Internal Linking Strategy

### Links FROM Plugin Page TO:
1. `/categories/skill-enhancers` - "Part of Skill Enhancers collection"
2. `/getting-started` - "New to Claude Code plugins?"
3. `/sponsor` - "Support plugin development"
4. `/plugins/search-to-slack` - "Related: Search to Slack (Pro)"
5. `/plugins/file-to-code` - "Related: File to Code (Pro)"
6. `/docs/creating-plugins` - "Build your own Skill Enhancer"

### Contextual Link Examples:
```markdown
This plugin is part of the [Skill Enhancers](#) collection that extends
Claude's AI capabilities with workflow automation.

Want to automate Slack digests too? Check out [search-to-slack](#) (Pro tier).

New to Claude Code? Read our [getting started guide](#) first.

[Support open source development](#) with GitHub Sponsors.
```

### Footer Links:
- View on GitHub
- Report an Issue
- Request a Feature
- Join Discord Community
- Browse All Plugins

## Image Requirements

### Hero Image (1200x600px)
**File:** `/public/images/plugins/web-to-github-issue-hero.png`
**Content:**
- Screenshot of Claude interface showing research command
- Arrow pointing to
- Screenshot of generated GitHub issue
- Badge: "FREE • 95% Time Saved"

### OG Image (1200x630px)
**File:** `/public/images/plugins/web-to-github-issue-og.png`
**Content:**
- Headline: "Web → GitHub Issue"
- Subheadline: "Claude AI automation for developers"
- Visual: Flow diagram (Research → Plugin → GitHub)
- Stats: "FREE • 30 sec setup • 95% time saved"

### Demo GIF (800x500px)
**File:** `/public/images/plugins/web-to-github-issue-demo.gif`
**Content:**
- Claude command entered
- Web search results shown
- GitHub issue being created
- Final issue displayed
- Duration: 10 seconds, loops

### Screenshot Gallery (800x500px each)
```html
<div class="screenshot-gallery">
  <img src="/images/web-to-github-issue-step1.png"
       alt="Step 1: Ask Claude to research and create GitHub issue with natural language command"
       width="800" height="500" />

  <img src="/images/web-to-github-issue-step2.png"
       alt="Step 2: Claude performs web search using web_search Skill"
       width="800" height="500" />

  <img src="/images/web-to-github-issue-step3.png"
       alt="Step 3: Plugin automatically formats research into GitHub issue"
       width="800" height="500" />

  <img src="/images/web-to-github-issue-result.png"
       alt="Result: Formatted GitHub issue with summary, findings, sources, and action items"
       width="800" height="500" />
</div>
```

## Performance Optimization

### Critical CSS (Inline)
```css
.plugin-header { /* Above-the-fold styles */ }
.cta-primary { /* Primary CTA button */ }
.hero-image { /* Hero image container */ }
```

### Lazy Loading
```html
<img src="/images/web-to-github-issue-demo.gif"
     loading="lazy"
     decoding="async"
     alt="Web to GitHub Issue plugin demo" />
```

### Preload Critical Assets
```html
<link rel="preload" as="image" href="/images/web-to-github-issue-hero.png" />
<link rel="preload" as="font" href="/fonts/inter-var.woff2" crossorigin />
```

## Structured Data Testing

### Google Rich Results Test
**URL to Test:** `https://claudecodeplugins.io/plugins/web-to-github-issue`

**Expected Rich Results:**
- ✅ SoftwareApplication card with price ($0)
- ✅ Breadcrumb navigation
- ✅ HowTo accordion (installation steps)
- ✅ FAQ accordion (troubleshooting)
- ✅ Star rating (when reviews added)

## Mobile-Specific Optimizations

### Mobile Meta Tags
```html
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5" />
<meta name="mobile-web-app-capable" content="yes" />
<meta name="apple-mobile-web-app-title" content="Web→GitHub Issue" />
```

### Mobile CTA Positioning
```css
@media (max-width: 768px) {
  .cta-primary {
    position: sticky;
    bottom: 0;
    width: 100%;
    z-index: 1000;
    box-shadow: 0 -4px 12px rgba(0,0,0,0.2);
  }
}
```

## Conversion Tracking

### Goals to Track:
1. Install button clicks
2. GitHub token documentation link clicks
3. Time on page (target: 2:30+)
4. Scroll depth (target: 75%+)
5. Related plugin clicks
6. Sponsor page clicks from plugin page

### Event Tracking Code
```javascript
// Track install button click
document.querySelector('.install-button').addEventListener('click', () => {
  gtag('event', 'plugin_install_click', {
    'plugin_name': 'web-to-github-issue',
    'plugin_category': 'skill-enhancers',
    'plugin_tier': 'free'
  });
});
```

---

**Projected SEO Impact:**
- Target ranking: Top 3 for "Claude GitHub automation"
- Organic traffic: 150-200 visits/month
- Install conversion rate: 35% (visitors who install)
- Average time on page: 2:30
- Bounce rate: <40%
- Internal clicks: 2.5 avg per session (to related plugins, docs, sponsor)
