---
name: windsurf-core-workflow-b
description: |
  Execute Windsurf secondary workflow: Core Workflow B.
  Use when implementing secondary use case,
  or complementing primary workflow.
  Trigger with phrases like "windsurf secondary workflow",
  "secondary task with windsurf".
allowed-tools: Read, Write, Edit, Bash(npm:*), Grep
version: 1.0.0
license: MIT
author: Jeremy Longshore <jeremy@intentsolutions.io>
---

# Windsurf Core Workflow B

## Overview
Secondary workflow for Windsurf. Complements the primary workflow.

## Prerequisites
- Completed `windsurf-install-auth` setup
- Familiarity with `windsurf-core-workflow-a`
- Valid API credentials configured

## Instructions

### Step 1: Setup
```typescript
// Step 1 implementation
```

### Step 2: Process
```typescript
// Step 2 implementation
```

### Step 3: Complete
```typescript
// Step 3 implementation
```

## Output
- Completed Core Workflow B execution
- Results from Windsurf API
- Success confirmation or error details

## Error Handling
| Aspect | Workflow A | Workflow B |
|--------|------------|------------|
| Use Case | Primary | Secondary |
| Complexity | Medium | Lower |
| Performance | Standard | Optimized |

## Examples

### Complete Workflow
```typescript
// Complete workflow example
```

### Error Recovery
```typescript
// Error handling code
```

## Resources
- [Windsurf Documentation](https://docs.windsurf.com)
- [Windsurf API Reference](https://docs.windsurf.com/api)

## Next Steps
For common errors, see `windsurf-common-errors`.