# Zapier Zap Builder

Build multi-step Zapier automations with AI assistance - the easiest way to connect your apps.

## Why Zapier?

Zapier is the most popular automation platform:

-  **Easiest to Use** - No-code, visual interface
-  **5000+ Apps** - Largest integration ecosystem
-  **Quick Setup** - Get automations running in minutes
- ️ **Reliable** - Enterprise-grade uptime
-  **Mobile App** - Manage Zaps on the go
-  **Great Support** - Extensive docs and community

## Installation

```bash
/plugin marketplace add jeremylongshore/claude-code-plugins
/plugin install zapier-zap-builder
```

## Features

- **Multi-Step Zaps** - Chain multiple actions together
- **Filters** - Add conditional logic
- **Paths** - Create branching workflows
- **Formatters** - Transform data on the fly
- **Delays** - Add time-based triggers
- **AI Integration** - Native OpenAI support

## Commands

| Command | Description |
|---------|-------------|
| `/zap` | Build Zapier Zap configurations |

## Example Zaps

### 1. AI Email Assistant ($0.80/mo for 100 emails)
```
Gmail Trigger → OpenAI → Gmail Send → Sheets Log
```

### 2. Lead Qualification ($1.60/mo for 50 leads)
```
Webhook → OpenAI Score → Slack Alert → HubSpot Deal
```

### 3. Social Media Automation ($0.60/mo for 20 posts)
```
RSS → OpenAI Rewrite → Post to Twitter/LinkedIn/Facebook
```

## Getting Started

1. Install the plugin
2. Describe your automation need
3. Get step-by-step Zap configuration
4. Build in Zapier
5. Test and activate

## Zapier Pricing

- **Free:** 100 tasks/month (single-step only)
- **Starter:** $20/month for 750 tasks
- **Professional:** $49/month for 2,000 tasks

**Note:** Each action step = 1 task

## When to Use Zapier

**Best for:**
- Quick prototypes
- Non-technical users
- Largest app selection
- Premium/enterprise apps
- Managed service preference

## Requirements

- Claude Code >= 1.0.0
- Zapier account (free tier available)

## License

MIT

---

Part of [Claude Code Plugin Hub](https://github.com/jeremylongshore/claude-code-plugins)
